@extends('layouts.app')

@section('title', 'Iniciar Sesión - Herbal Solutions')
@section('body-class', 'login-page')

@section('content')
    <section id="login" class="section light-background">
        <div class="container">
            <div class="section-title" data-aos="fade-up">
                <h2>Iniciar Sesión</h2>
                <p>Accede a tu cuenta de Herbal Solutions.</p>
            </div>

            <div class="row justify-content-center" data-aos="fade-up" data-aos-delay="100">
                <div class="col-lg-6">
                    <div class="php-email-form" style="background: #fff; padding: 30px; border-radius: 8px; box-shadow: 0px 0px 30px rgba(0, 0, 0, 0.1);">
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                {{ $errors->first() }}
                            </div>
                        @endif

                        <form method="POST" action="{{ route('login') }}">
                            @csrf
                            <div class="form-group mb-4">
                                <label for="email" class="form-label">Correo Electrónico</label>
                                <input type="email" name="email" id="email" class="form-control" value="{{ old('email') }}" required>
                            </div>

                            <div class="form-group mb-4">
                                <label for="password" class="form-label">Contraseña</label>
                                <input type="password" name="password" id="password" class="form-control" required>
                            </div>

                            <div class="text-center">
                                <button type="submit" class="btn btn-primary" style="background: var(--accent-color); border: none; padding: 10px 30px;">Iniciar Sesión</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection