<!-- resources/views/about.blade.php -->
@extends('layouts.app')

@section('content')
    <!-- Page Title -->
    <div class="page-title dark-background">
      <div class="container d-lg-flex justify-content-between align-items-center">
        <h1 class="mb-2 mb-lg-0">About</h1>
        <nav class="breadcrumbs">
          <ol>
            <li><a href="{{ url('/') }}" class="{{ request()->is('/') ? 'active' : '' }}">Home</a></li>
            <li class="current">About</li>
          </ol>
        </nav>
      </div>
    </div><!-- End Page Title -->

    <!-- About Section -->
    <section id="about" class="about section">

      <div class="container">

        <div class="row gy-4">          
          <div class="col-lg-6" data-aos="fade-up" data-aos-delay="100">
            <div class="content ps-0 ps-lg-5">
              <h3>{{ __('messages.abouth3') }}</h3>
              <img src="{{ asset('assets/img/about.jpg') }}" class="img-fluid rounded-4 mb-4" alt="">
              <ul>
                <li><i class="bi bi-check-circle-fill"></i> <span>{{ __('messages.lista1') }}</span></li>
                <p class="fst-italic">{{ __('messages.listap1') }} </p>
                <li><i class="bi bi-check-circle-fill"></i> <span>{{ __('messages.lista2') }}</span></li>
                <p class="fst-italic">{{ __('messages.listap2') }}</p>
                <li><i class="bi bi-check-circle-fill"></i> <span>{{ __('messages.lista3') }}</span></li>
                <p class="fst-italic">{{ __('messages.listap3') }}</p>
              </ul>
            </div>
          </div>
          <div class="col-lg-6" data-aos="fade-up" data-aos-delay="250">
            <div class="content ps-0 ps-lg-5">
              <h4>{{ __('messages.creemos') }}</h4>
              <ul>
                <li><i class="bi bi-check-circle-fill"></i> <span>{{ __('messages.creemos1') }}</span></li>
                <li><i class="bi bi-check-circle-fill"></i> <span>{{ __('messages.creemos2') }}</span></li>
                <li><i class="bi bi-check-circle-fill"></i> <span>{{ __('messages.creemos3') }}</span></li>
                <li><i class="bi bi-check-circle-fill"></i> <span>{{ __('messages.creemos4') }}</span></li>
                <li><i class="bi bi-check-circle-fill"></i> <span>{{ __('messages.creemos5') }}</span></li>
                <li><i class="bi bi-check-circle-fill"></i> <span>{{ __('messages.creemos6') }}</span></li>
                <li><i class="bi bi-check-circle-fill"></i> <span>{{ __('messages.creemos7') }}</span></li>
                <li><i class="bi bi-check-circle-fill"></i> <span>{{ __('messages.creemos8') }}</span></li>
              </ul>
              <h4>{{ __('messages.acuerdo') }}</h4>
              <ul>
                <li><i class="bi bi-x-circle-fill text-danger"></i> <span>{{ __('messages.acuerdo1') }}</span></li>
                <li><i class="bi bi-x-circle-fill text-danger"></i> <span>{{ __('messages.acuerdo2') }}</span></li>
                <li><i class="bi bi-x-circle-fill text-danger"></i> <span>{{ __('messages.acuerdo3') }}</span></li>
                <li><i class="bi bi-x-circle-fill text-danger"></i> <span>{{ __('messages.acuerdo4') }}</span></li>
                <li><i class="bi bi-x-circle-fill text-danger"></i> <span>{{ __('messages.acuerdo5') }}</span></li>
                <li><i class="bi bi-x-circle-fill text-danger"></i> <span>{{ __('messages.acuerdo6') }}</span></li>
              </ul>
              <!--<div class="position-relative mt-4">
                <img src="{{ asset('assets/img/about-2.jpg') }}" class="img-fluid rounded-4" alt="">
                <a href="https://www.youtube.com/watch?v=Y7f98aduVJ8" class="glightbox pulsating-play-btn"></a>
              </div>
            </div>-->
            <div class="position-relative mt-4">
              <img src="{{ asset('assets/img/about-2.jpg') }}" class="img-fluid" alt="">
              <video class="glightbox pulsating-play-btn" controls>
                <source src="{{ asset('assets/videos/video_about.mp4') }}" type="video/mp4">
                Your browser does not support the video tag.
              </video>
            </div>
          </div>
        </div>

      </div>

    </section><!-- /About Section -->
@endsection
