document.addEventListener('DOMContentLoaded', () => {
    console.log('3. Script ejecutándose desde store.js');
    const buttons = document.querySelectorAll('.add-to-cart');
    console.log('4. Botones encontrados:', buttons.length);

    if (buttons.length === 0) {
        console.error('No se encontraron botones .add-to-cart. Verifica el HTML.');
        return;
    }

    buttons.forEach(button => {
        button.addEventListener('click', () => {
            console.log('5. Botón clicado, ID del producto:', button.getAttribute('data-product-id'));
            const productId = button.getAttribute('data-product-id');
            const quantityInput = button.closest('.portfolio-info').querySelector('input[type="number"]');
            const quantity = parseInt(quantityInput.value) || 1;
            console.log('6. Datos a enviar:', { product_id: productId, quantity });

            fetch('/cart/add', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                },
                body: JSON.stringify({ product_id: productId, quantity })
            })
            .then(response => {
                console.log('7. Estado de la respuesta:', response.status);
                if (!response.ok) {
                    return response.text().then(text => { throw new Error(`Error ${response.status}: ${text}`); });
                }
                return response.json();
            })
            .then(data => {
                console.log('8. Respuesta del servidor:', data);
                window.updateCart(data.cart, true); // Actualizar carrito y abrir modal
            })
            .catch(error => {
                console.error('Error al añadir al carrito:', error);
            });
        });
    });
});