window.storeJsLoaded = true; // Marcar que se cargó
console.log('store.js se ha cargado en la página');

document.addEventListener('DOMContentLoaded', function () {
    console.log('Página completamente cargada');

    // Verificar botones .add-to-cart en el DOM
    const addToCartButtons = document.querySelectorAll('.add-to-cart');
    console.log('Botones .add-to-cart encontrados:', addToCartButtons.length, addToCartButtons);

    // Verificar token CSRF
    const csrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content');
    if (!csrfToken) {
        console.error('Error: No se encontró el token CSRF. Asegúrate de que <meta name="csrf-token"> está en el <head>.');
    }

    // Capturar todos los clics para depuración
    document.addEventListener('click', function (e) {
        console.log('Clic capturado en:', e.target, 'Clases:', e.target.className);
        if (e.target.classList.contains('add-to-cart')) {
            e.preventDefault();
            console.log('Botón .add-to-cart clicado');
            const button = e.target;
            const productId = button.getAttribute('data-product-id');
            const quantityInput = button.closest('.card-body').querySelector('.quantity-box input');
            const quantity = quantityInput ? quantityInput.value : '1';

            console.log('Producto ID:', productId, 'Cantidad:', quantity, 'Tipo:', typeof quantity);

            // Enviar datos como formulario
            const formData = new FormData();
            formData.append('product_id', productId);
            formData.append('quantity', quantity);

            fetch('/cart/add', {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': csrfToken
                },
                body: formData
            })
            .then(response => {
                console.log('Respuesta del servidor:', response.status, response.statusText);
                if (!response.ok) {
                    throw new Error('Error HTTP: ' + response.status);
                }
                return response.json();
            })
            .then(data => {
                console.log('Datos recibidos:', data);
                if (data.success) {
                    console.log('Producto añadido, actualizando carrito');
                    window.updateCart(data.cart, true);
                } else {
                    console.error('Error del servidor:', data);
                    alert('Error al añadir al carrito: ' + (data.message || data.error || 'Inténtalo de nuevo'));
                }
            })
            .catch(error => {
                console.error('Error en la solicitud:', error);
                alert('Error al añadir al carrito: ' + error.message);
            });
        }
    });
});