<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddCategoryToProductsTable extends Migration
{
    public function up()
    {
        Schema::table('products', function (Blueprint $table) {
            $table->enum('category', [
                'cinturita',
                'Dietary_Supplement',
                'Digestion_Gut',
                'Digestive_Intestinal',
                'Teas',
                'Weight_Management',
                'Cleansing_Detox',
                'Fiber',
                'Bones_Joints',
                'Hair_Care',
                'Capsules',
                'Hair_Skin_and_Nails',
                'Skeletal_System',
                'Hepatic_Portal',
                'Shampoo',
                'Personal_hygiene',
                'Conditioner',
                'Corporal_Care',
                'Aches_Pains',
                'Ointment'
            ])->nullable()->after('image');
        });
    }

    public function down()
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn('category');
        });
    }
}