<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ContactMail extends Mailable
{
    use Queueable, SerializesModels;

    public $data;

    public function __construct($data)
    {
        $this->data = $data;
    }

    public function build()
    {
        return $this->subject($this->data['subject'])
                    ->from($this->data['email'], $this->data['name'])
                    ->to('ernestico0693@gmail.com')
                    ->view('emails.contact')
                    ->with(['data' => $this->data]);
    }
}