<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class RegisterController extends Controller
{
    public function showRegistrationForm()
    {
        return view('register');
    }

    public function submit(Request $request)
    {
        // Validar los datos del formulario
        $request->validate([
            'first_name' => 'required|string|max:255',
            'last_name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'phone' => 'required|string|max:20',
            'account_type' => 'required|in:individual_customer,wholesale_account',
        ]);

        // Datos para el correo
        $data = [
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'email' => $request->email,
            'phone' => $request->phone,
            'account_type' => $request->account_type == 'individual_customer' ? __('messages.individual_customer') : __('messages.wholesale_account'),
        ];

        // Enviar correo
        Mail::raw(
            "New Registration:\n\n" .
            "First Name: {$data['first_name']}\n" .
            "Last Name: {$data['last_name']}\n" .
            "Email: {$data['email']}\n" .
            "Phone: {$data['phone']}\n" .
            "Account Type: {$data['account_type']}",
            function ($message) {
                $message->to('ernestico0693@gmail.com')
                        ->subject('New Registration from Herbal Solutions');
            }
        );

        // Redirigir con mensaje de éxito
        return redirect()->route('client.register')->with('success', __('messages.registration_success'));
    }
}