<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log; // Añadido este import

class LanguageController extends Controller
{
    public function switch(Request $request)
    {
        $language = $request->input('language');
        if (in_array($language, ['en', 'es'])) {
            session(['locale' => $language]);
            Log::info('Language switched to: ' . $language);
            Log::info('Session locale: ' . session('locale'));
        }
        return redirect()->back();
    }
}