<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Mail\ContactMail;

class ContactController extends Controller
{
    public function send(Request $request)
    {
        // Validar los datos del formulario
        $data = $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'subject' => 'required|string|max:255',
            'message' => 'required|string',
        ]);

        try {
            // Intentar enviar el correo
            Mail::to('ernestico0693@gmail.com')->send(new ContactMail($data));
            
            // Registro en el log para confirmar que el correo se envió
            \Log::info('Correo enviado correctamente', $data);
            
            return redirect()->route('contact')->with('success', 'Tu mensaje ha sido enviado. ¡Gracias!');
        } catch (\Exception $e) {
            // Registro en el log del error para depuración
            \Log::error('Error al enviar el correo: ' . $e->getMessage(), [
                'data' => $data,
                'trace' => $e->getTraceAsString()
            ]);
            
            return redirect()->route('contact')->with('error', 'Error al enviar el correo: ' . $e->getMessage());
        }
    }
}