<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Product;
use Illuminate\Http\Request;

class ProductController extends Controller
{
    public function index()
    {
        $products = Product::all();
        return view('admin.products.index', compact('products'));
    }

    public function create()
    {
        $categories = [
            'cinturita' => __('messages.waistline'),
            'Dietary_Supplement' => __('messages.dietary_supplement'),
            'Digestion_Gut' => __('messages.digestion_stomach'),
            'Digestive_Intestinal' => __('messages.digestive_intestinal'),
            'Teas' => __('messages.teas'),
            'Weight_Management' => __('messages.weight_control'),
            'Cleansing_Detox' => __('messages.cleansing_detox'),
            'Fiber' => __('messages.fiber'),
            'Bones_Joints' => __('messages.bones_joints'),
            'Hair_Care' => __('messages.hair_care'),
            'Capsules' => __('messages.capsules'),
            'Hair_Skin_and_Nails' => __('messages.hair_skin_nails'),
            'Skeletal_System' => __('messages.skeletal_system'),
            'Hepatic_Portal' => __('messages.hepatic_portal'),
            'Shampoo' => __('messages.shampoo'),
            'Personal_hygiene' => __('messages.personal_hygiene'),
            'Conditioner' => __('messages.conditioner'),
            'Corporal_Care' => __('messages.body_care'),
            'Aches_Pains' => __('messages.pains_aches'),
            'Ointment' => __('messages.ointment'),
        ];
        return view('admin.products.create', compact('categories'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'price' => 'required|numeric|min:0',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            'category' => 'required|in:cinturita,Dietary_Supplement,Digestion_Gut,Digestive_Intestinal,Teas,Weight_Management,Cleansing_Detox,Fiber,Bones_Joints,Hair_Care,Capsules,Hair_Skin_and_Nails,Skeletal_System,Hepatic_Portal,Shampoo,Personal_hygiene,Conditioner,Corporal_Care,Aches_Pains,Ointment',
            'is_discounted' => 'nullable|boolean',
            'discount_price' => 'nullable|numeric|min:0|lte:price',
        ]);

        $data = $request->only(['name', 'description', 'price', 'category', 'is_discounted', 'discount_price']);
        $data['is_discounted'] = $request->has('is_discounted') ? 1 : 0;

        if ($request->hasFile('image')) {
            $path = $request->file('image')->store('products', 'public');
            $data['image'] = $path;
        }

        Product::create($data);

        return redirect()->route('admin.products.index')->with('success', 'Producto creado exitosamente.');
    }

    public function edit(Product $product)
    {
        $categories = [
            'cinturita' => __('messages.waistline'),
            'Dietary_Supplement' => __('messages.dietary_supplement'),
            'Digestion_Gut' => __('messages.digestion_stomach'),
            'Digestive_Intestinal' => __('messages.digestive_intestinal'),
            'Teas' => __('messages.teas'),
            'Weight_Management' => __('messages.weight_control'),
            'Cleansing_Detox' => __('messages.cleansing_detox'),
            'Fiber' => __('messages.fiber'),
            'Bones_Joints' => __('messages.bones_joints'),
            'Hair_Care' => __('messages.hair_care'),
            'Capsules' => __('messages.capsules'),
            'Hair_Skin_and_Nails' => __('messages.hair_skin_nails'),
            'Skeletal_System' => __('messages.skeletal_system'),
            'Hepatic_Portal' => __('messages.hepatic_portal'),
            'Shampoo' => __('messages.shampoo'),
            'Personal_hygiene' => __('messages.personal_hygiene'),
            'Conditioner' => __('messages.conditioner'),
            'Corporal_Care' => __('messages.body_care'),
            'Aches_Pains' => __('messages.pains_aches'),
            'Ointment' => __('messages.ointment'),
        ];
        return view('admin.products.edit', compact('product', 'categories'));
    }

    public function update(Request $request, Product $product)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'price' => 'required|numeric|min:0',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            'category' => 'required|in:cinturita,Dietary_Supplement,Digestion_Gut,Digestive_Intestinal,Teas,Weight_Management,Cleansing_Detox,Fiber,Bones_Joints,Hair_Care,Capsules,Hair_Skin_and_Nails,Skeletal_System,Hepatic_Portal,Shampoo,Personal_hygiene,Conditioner,Corporal_Care,Aches_Pains,Ointment',
            'is_discounted' => 'nullable|boolean',
            'discount_price' => 'nullable|numeric|min:0|lte:price',
        ]);

        $data = $request->only(['name', 'description', 'price', 'category', 'is_discounted', 'discount_price']);
        $data['is_discounted'] = $request->has('is_discounted') ? 1 : 0;

        if ($request->hasFile('image')) {
            $path = $request->file('image')->store('products', 'public');
            $data['image'] = $path;
        }

        $product->update($data);

        return redirect()->route('admin.products.index')->with('success', 'Producto actualizado exitosamente.');
    }

    public function destroy(Product $product)
    {
        $product->delete();
        return redirect()->route('admin.products.index')->with('success', 'Producto eliminado exitosamente.');
    }
}